﻿© Fluke Calibration. All Rights Reserved.                  MET/CAL Procedure
=============================================================================
INSTRUMENT:            NI PXI-4130: (1 year) CAL VER LIB /8508
DATE:                  2011-11-21 14:57:45
AUTHOR:                Fluke
REVISION:              $Revision: 1.7 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       199
CONFIGURATION:         Fluke 8508A
=============================================================================
#
#  Text Source:
#    $RCSfile: ni_pxi-4130_1yr_ver_lib_8508.txt,v $
#    $Date: 2011/12/08 19:46:14 $
#
#  Procedure Author:
#        DAC
#@
#@ Models covered:
#@       PXI-4130
#@
#@ Source(s):
#@       Calibration Procedure
#@       NI PXI-4130
#@       PN 374753B-01
#@       ©2008 National Instruments Corporation
#@
#@ Compatibility:
#@       MET/CAL 8.0.34 or later
#
#  Subprocedures:
#        Sub Display Copyright
#        Sub Select Failed Test Mode
#        Sub Select Verification Method (No NTHROW)
#        Sub PXI Setup
#        Sub NI PXI-4130 (1 yr) V Prog Acc Ch0 VER LIB /8508
#        Sub NI PXI-4130 (1 yr) V Prog Acc Ch1 VER LIB /8508
#        Sub NI PXI-4130 (1 yr) V Meas Acc Ch0 VER LIB /8508
#        Sub NI PXI-4130 (1 yr) V Meas Acc Ch1 VER LIB /8508
#        Sub NI PXI-4130 (1 yr) I Prog Acc Ch0 VER LIB /8508
#        Sub NI PXI-4130 (1 yr) I Prog Acc Ch1 VER LIB /8508
#        Sub NI PXI-4130 (1 yr) I Meas Acc Ch0 VER LIB /8508
#        Sub NI PXI-4130 (1 yr) I Meas Acc Ch1 VER LIB /8508
#        Sub NI PXI-4130 (1 yr) 6 V Prog Acc Ch0 Test LIB /8508
#        Sub NI PXI-4130 (1 yr) 6 V Prog Acc Ch1 Test LIB /8508
#        Sub NI PXI-4130 (1 yr) 20 V Prog Acc Ch1 Test LIB /8508
#        Sub NI PXI-4130 (1 yr) 6 V Meas Acc Ch0 Test LIB /8508
#        Sub NI PXI-4130 (1 yr) 20 V Meas Acc Ch1 Test LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 200 µA Prog Tests LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 2 mA Prog Tests LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 20 mA Prog Tests LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 200 mA Prog Tests LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 2 A Prog Tests LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 200 µA Prog Test LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 2 mA Prog Test LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 20 mA Prog Test LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 200 mA Prog Test LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 2 A Prog Test LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 200 µA Meas Tests LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 2 mA Meas Tests LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 20 mA Meas Tests LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 200 mA Meas Tests LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 2 A Meas Tests LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 200 µA Meas Test LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 2 mA Meas Test LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 20 mA Meas Test LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 200 mA Meas Test LIB /8508
#        Sub NI PXI-4130 (1 yr) Ch1 2 A Meas Test LIB /8508
#        Sub NI PXI-4130 Terminate LIB
#        Sub NI DC Power Init LIB
#        Sub NI DC Power Setup LIB
#        Sub NI DC Power Output Off LIB
#        Sub NI DC Power Error Message LIB
#        Sub NI DC Power Contants
#        Sub IVI DC Power Contants
#        Sub IVI Visa Constants
#        Sub IVI Contants
#
#  Required Files:
#        None
#
#@ Additional Equipment Required:
#@       None
#@
#  The procedure was tested using:
#
#        Model No  : PXI-4130
#        Serial No : 1361211
#        Options   : None
#        Firmware  : Unknown
#
#  Average run time during testing : 15 minutes (TAR mode)
#                                    23 minutes (MU mode)
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  8508         *                                                 S
  1.003  ENDIF

  1.004  ASK-   R   Q N              P                            A        V
  1.005  ASK+           K

  1.006  IF           NOT(VERSIONCHECK("8.0.34"))
  1.007  END
  1.008  ENDIF

  1.009  MATH         @ModelNum = "PXI-4130"
  1.010  CALL         Sub PXI Setup

  1.011  IF           @Abort
  1.012  END
  1.013  ENDIF

  1.014  CALL         Sub IVI Visa Constants
  1.015  CALL         Sub NI DC Power Constants
# Call "Sub NI DC Power Init LIB" here to determine if communication with
# PXI module has been established.
  1.016  CALL         Sub NI DC Power Init LIB
  1.017  CLEAR        -c Sub NI PXI-4130 Terminate LIB

  1.018  CALL         Sub Display Copyright
  1.019  CALL         Sub Select Failed Test Mode
  1.020  CALL         Sub Select Verification Method (No NTHROW)

  1.021  HEAD         PRELIMINARY INSTRUCTIONS
  1.022  DISP         Ambient temperature: 18 °C - 28 °C.
  1.022  DISP         Relative humidity: less than 70 %.
  1.022  DISP         Warmup time: 1 hour.

# NOTE: Throughout this procedure, JMPL/LABEL statements are used to minimize
# connection changes during execution.  Test results, however, are reported
# in test number sequence.
#
#          Results Order                  Execution Order
#    1.    DCV Programming Ch 0           DCV Programming Ch 0
#    2.    DCV Programming Ch 1           DCV Measurement Ch 0
#    3.    DCV Measurement Ch 0           DCV Programming Ch 1
#    4.    DCV Measurement Ch 1           DCV Measurement Ch 1
#    5.    DCI Programming Ch 0           DCI Programming Ch 0
#    6.    DCI Programming Ch 1           DCI Measurement Ch 0
#    7.    DCI Measurement Ch 0           DCI Programming Ch 1
#    8.    DCI Measurement Ch 1           DCI Measurement Ch 1

  1.023  MATH         @niDCPwrFunc = @niDCPwrValDCV

  1.024  DISP         Connect a DC power supply to UUT AUX POWER INPUT.
  1.024  DISP
  1.024  DISP         Set the power supply to +12 V.
  1.024  DISP
  1.024  DISP         If possible, set the current limit to 3 A.
  1.024  DISP
  1.024  DISP         Enable the output.

  1.025  RESET        -c Sub NI DC Power Output Off LIB

  1.026  CALL         Sub NI PXI-4130 (1 yr) V Prog Acc Ch0 VER LIB /8508
  1.027  JMPL         VOLTAGE_MEASUREMENT_ACCURACY_CH0

  1.028  LABEL        VOLTAGE_PROGRAMMING_ACCURACY_CH1
  1.029  CALL         Sub NI PXI-4130 (1 yr) V Prog Acc Ch1 VER LIB /8508
  1.030  JMPL         VOLTAGE_MEASUREMENT_ACCURACY_CH1

  1.031  LABEL        VOLTAGE_MEASUREMENT_ACCURACY_CH0
  1.032  CALL         Sub NI PXI-4130 (1 yr) V Meas Acc Ch0 VER LIB /8508
  1.033  JMPL         VOLTAGE_PROGRAMMING_ACCURACY_CH1

  1.034  LABEL        VOLTAGE_MEASUREMENT_ACCURACY_CH1
  1.035  CALL         Sub NI PXI-4130 (1 yr) V Meas Acc Ch1 VER LIB /8508
  1.036  CALL         Sub NI PXI-4130 (1 yr) I Prog Acc Ch0 VER LIB /8508
  1.037  JMPL         CURRENT_MEASUREMENT_ACCURACY_CH0

  1.038  LABEL        CURRENT_PROGRAMMING_ACCURACY_CH1
  1.039  CALL         Sub NI PXI-4130 (1 yr) I Prog Acc Ch1 VER LIB /8508
  1.040  JMPL         CURRENT_MEASUREMENT_ACCURACY_CH1

  1.041  LABEL        CURRENT_MEASUREMENT_ACCURACY_CH0
  1.042  CALL         Sub NI PXI-4130 (1 yr) I Meas Acc Ch0 VER LIB /8508
  1.043  JMPL         CURRENT_PROGRAMMING_ACCURACY_CH1

  1.044  LABEL        CURRENT_MEASUREMENT_ACCURACY_CH1
  1.045  CALL         Sub NI PXI-4130 (1 yr) I Meas Acc Ch1 VER LIB /8508

  1.046  HEAD         V E R I F I C A T I O N   C O M P L E T E
  1.047  END
